<?php
namespace boru\queue\Storage;

use boru\queue\Entity\QueueItem;

interface QueueStorageInterface
{
    /**
     * Enqueue a new job.
     *
     * @param string $queueName
     * @param string $taskName
     * @param string $payload JSON string or other data
     * @return QueueItem
     */
    public function enqueue($queueName, $taskName, $payload);

    /**
     * Reserve the next available item for processing (status 0 -> 1).
     *
     * @param string $queueName
     * @return QueueItem|null
     */
    public function reserveNext($queueName);

    /**
     * Persist changes to the item (status/result/timestamps).
     *
     * @param QueueItem $item
     * @return void
     */
    public function save(QueueItem $item);

    /**
     * Mark item as done (status=2).
     *
     * @param QueueItem $item
     * @param string|null $result
     * @return void
     */
    public function markDone(QueueItem $item, $result);

    /**
     * Mark item as error (status=3).
     *
     * @param QueueItem $item
     * @param string|null $errorResult
     * @return void
     */
    public function markError(QueueItem $item, $errorResult);

    /**
     * Prune old items from the queue.
     * @param string $queueName
     * @param \DateTime $before
     * @return int number of deleted items
     */
    public function pruneOldItems($queueName, \DateTime $before);
}
