<?php

require __DIR__ . '/../../vendor/autoload.php';

use boru\dhdb\dhDB;
use boru\queue\Queue;
use boru\queue\Task\TaskRegistry;
use boru\queue\Task\ClosureTask;
use boru\queue\Entity\QueueItem;
use boru\queue\Dhprocess\DhOptions;

//1) DB
$db =  new dhDB(['dbtype'=>'mysql',
    "dbhost"=>"localhost",
    "dbport"=>"3306",
    "dbuser"=>"",
    "dbpass"=>"",
    "dbname"=>""
]);

// 2) Queue
$queue = (new Queue())
    ->withDbStorage($db, 'queue_items')
    ->setQueueName('default')
    ->withBootstrap(__FILE__)   // <--- important for async

    ->registerTask('demo_task', function (QueueItem $item, array $payload) {
        file_put_contents(
            __DIR__ . '/demo_task.log',
            date('c') . " - Sending to " . $payload['to'] . "\n",
            FILE_APPEND
        );
        return ["sent" => $payload['to'], "time" => date('c')];
    });

// Configure worker in both parent and worker processes
$queue->configureDhWorker();