<?php

use boru\dhdb\dhDB;
use boru\queue\Dhprocess\QueueDhWorker;
use boru\queue\Storage\MysqlQueueStorage;
use boru\queue\Task\TaskRegistry;
use boru\queue\Task\ClosureTask; // or concrete task classes

require __DIR__ . '/../../vendor/autoload.php';

$db =  new dhDB(['dbtype'=>'mysql',
    "dbhost"=>"localhost",
    "dbport"=>"3306",
    "dbuser"=>"",
    "dbpass"=>"",
    "dbname"=>""
]);

$queueStorage = new MysqlQueueStorage($db, 'queue_items');

$taskRegistry = new TaskRegistry();

// Register your tasks here – must match task_name stored in queue rows

// Example: a concrete task class
// $registry->register(new \YourApp\Tasks\SendEmailTask(/* deps */));

// Example: using ClosureTask for quick wiring
$taskRegistry->register(new ClosureTask('demo_task', function (\boru\queue\Entity\QueueItem $item, array $payload) {
    // Do some work...
    //make a result object
    $result = ["when" => date('c'), "status" => "done"];
    //add some randomness to the result in a demo way
    $result['random'] = rand(1, 1000);
    // Return any JSON-serializable result
    
    return array(
        'handled_item_id' => $item->getId(),
        'payload'         => $payload,
        'result'          => $result,
    );
}));

// 1) Configure how workers build QueueStorageInterface
QueueDhWorker::configure($queueStorage, $taskRegistry);