<?php
namespace boru\slack;

class Slack extends \wrapi\wrapi {
    public function __construct($token) {

        $opts = array(
            "headers" => array(
                "User-Agent" => "slack-wrapi",
                "Authorization" => "Bearer ". $token
            )
        );

        $json = file_get_contents(__DIR__. '/api/slack.json');
        $endpoints = json_decode($json, true);
        parent::__construct('https://slack.com/api/',
            $endpoints,
            $opts);
    }

    private static $instance;
    private static $token;
    public static function init($token) {
        if (!self::$instance || self::$token != $token) {
            self::$instance = new Slack($token);
            self::$token = $token;
        }
        return self::$instance;
    }

    public static function Message($channel,$altText="",$blocks = []) {
        $message = new Message($channel,$altText,$blocks);
    }
    public static function sendMessage($message) {
        $array = ["channel"=>$message->channel(), "blocks"=>json_encode($message),"text"=>$message->altText()];
        //print_r($array);
        //exit();
        return self::$instance->chat->postMessage($array);
    }
}