<?php
namespace boru\slack;

use boru\dhapi\API;
use boru\dhapi\routing\Route;
use boru\dhapi\routing\Router;
use boru\dhapi\core\Response;
use boru\dhapi\core\Dispatcher;

class WebHook {

    private static $eventHandlers = [];
    private static $handlers = [];

    private static $response;

    public static function init() {


        static::on("url_verification",function($array,$dispatcher) {
            $challenge = $dispatcher->body('challenge',false);
            if($challenge === false) {
                static::emit(Response::fromError("No challenge specified",400));
            }
            static::emit(Response::fromSuccess(["challenge"=>$challenge],200));
        });

        static::on("event",function($array,$dispatcher) {
            $event = $dispatcher->body('event',false);
            if($event === false) {
                static::emit(Response::fromError("No event specified",400));
            }
            $event_type = $event['type'];
           
            $handlers=0;
            if(isset(self::$eventHandlers[$event_type])) {
                foreach(self::$eventHandlers[$event_type] as $callback) {
                    $handlers++;
                    $callback($event,$dispatcher);
                }
            }
            if($handlers == 0) {
                static::emit(Response::fromError("No event handler for event type: ".$event_type,200));
            }
            static::emit(Response::fromSuccess(["handlers"=>$handlers],200));
        });

        $router = new Router();
        $router->add(new Route('main','/',['GET','POST','PUT','HEAD'],function($api) {
            return WebHook::callback($api);
        }));
        $request = API::requestFromGlobals();
        $api = new API($request,$router);
        $response = $api->process();
        $response->emit(true);
    }

    /**
     * 
     * @param Dispatcher $dispatcher 
     * @return void 
     */
    public static function callback($dispatcher) {
        //$test = $api->body('test.val',"notset");
        //return new Response(["test"=>$test],200);

        $type = $dispatcher->body('type',false);
        if($type === false) {
            return Response::fromError("No type specified",400);
        }
        $handlers=0;
        if(isset(self::$handlers[$type])) {
            foreach(self::$handlers[$type] as $callback) {
                $handlers++;
                $callback($dispatcher->body(),$dispatcher);
            }
        }
        static::emit(Response::fromSuccess(["handlers"=>$handlers],200));
    }

    public static function on($type,$callback) {
        if(!isset(self::$handlers[$type])) {
            self::$handlers[$type] = [];
        }
        self::$handlers[$type][] = $callback;
    }
    public static function onEvent($event,$callback) {
        if(!isset(self::$eventHandlers[$event])) {
            self::$eventHandlers[$event] = [];
        }
        self::$eventHandlers[$event][] = $callback;
    }

    public static function emit($response=null) {
        if($response === null) {
            $response = static::$response;
        }
        if(!($response instanceof Response)) {
            if(!empty($response)) {
                if(is_array($response) || is_object($response)) {
                    $response = Response::fromSuccess($response,200);
                } else {
                    $response = Response::fromSuccess(["response"=>$response],200);
                }
            } else {
                $response = Response::fromSuccess([],200);
            }
        }
        $response->emit(true);
        exit();
    }
}