<?php
namespace boru\slack\message\blocks;

use boru\slack\message\Block;

class HeaderBlock extends Block {
    private $type = 'header';
    private $text = [];

    public function __construct($text) {
        $this->text['type'] = "plain_text";
        $this->text["text"] = $text;
    }

    public function toArray() {
        $array = [
            'type' => $this->type,
            'text' => $this->text,
        ];
        return $array;
    }
}