<?php
namespace boru\slack\message\blocks;

use boru\slack\message\Block;

class TextBlock extends Block {
    private $type = 'section';
    private $text;
    private $fields = [];
    private $accessory = [];

    public function __construct($text, $textType="mrkdwn", $fields = [], $accessory = []) {
        $this->text['type'] = $textType;
        $this->text["text"] = $text;
        $this->fields = $fields;
        $this->accessory = $accessory;
    }

    public function toArray() {
        $array = [
            'type' => $this->type,
            'text' => $this->text,
        ];
        if (count($this->fields) > 0) {
            $array['fields'] = $this->fields;
        }
        if (count($this->accessory) > 0) {
            $array['accessory'] = $this->accessory;
        }
        return $array;
    }
}