<?php
namespace boru\slack;

class Message implements \JsonSerializable {
    private $blocks;
    private $altText = "";
    private $channel = "";

    public function __construct($channel,$altText="",$blocks = []) {
        $this->altText = $altText;
        $this->channel = $channel;
        $this->blocks = $blocks;
    }
    public function add($block) {
        $this->blocks[] = $block;
    }
    public function altText($altText=null) {
        if($altText === null) return $this->altText;
        $this->altText = $altText;
        return $this;
    }
    public function channel($channel=null) {
        if($channel === null) return $this->channel;
        $this->channel = $channel;
        return $this;
    }

    public function toArray() {
        return $this->blocks;
    }
    public function jsonSerialize() {
        return $this->toArray();
    }
    public function __toString() {
        return json_encode($this->toArray());
    }


    public static function SectionBlock($fields=[],$accessory=[]) {
        return new message\blocks\SectionBlock($fields,$accessory);
    }
    public static function TextBlock($text) {
        return new message\blocks\TextBlock($text);
    }
    public static function HeaderBlock($text) {
        return new message\blocks\HeaderBlock($text);
    }
    public static function DividerBlock() {
        return new message\blocks\DividerBlock();
    }
    public static function ContextBlock($elements=[]) {
        return new message\blocks\ContextBlock($elements);
    }
    public static function Image($url, $altText) {
        return new message\elements\Image($url, $altText);
    }
    public static function Field($text, $emoji = false) {
        return new message\elements\Field($text, $emoji);
    }
    public static function Text($text, $textType="mrkdwn", $emoji = false) {
        return new message\elements\TextElement($text, $textType, $emoji);
    }
}