<?php
namespace boru\slack\message\blocks;

use boru\slack\message\Block;

class SectionBlock extends Block {
    private $type = 'section';
    private $fields = [];
    private $accessory = [];

    public function __construct($fields = [], $accessory = []) {
        $this->fields = $fields;
        $this->accessory = $accessory;
    }

    public function toArray() {
        $array = [
            'type' => $this->type,
        ];
        if (count($this->fields) > 0) {
            $array['fields'] = $this->fields;
        }
        if (count($this->accessory) > 0) {
            $array['accessory'] = $this->accessory;
        }
        return $array;
    }

    public function addField($block) {
        $this->fields[] = $block;
        return $this;
    }
}