<?php
namespace boru\slack\message\elements;

use boru\slack\message\Block;

class TextElement extends Block {
    private $type = "mrkdwn";
    private $text = '';
    private $emoji = false;

    public function __construct($text, $textType="mrkdwn", $emoji=false) {
        $this->text = $text;
        $this->type = $textType;
        $this->emoji = $emoji;
    }

    public function toArray() {
        $array = [
            'type' => $this->type,
            'text' => $this->text,
        ];
        if ($this->emoji) {
            $array['emoji'] = $this->emoji;
        }
        return $array;
    }
}