<?php

require __DIR__ . '/../vendor/autoload.php';

use boru\tty\Terminal;
use boru\tty\Prompt;
use boru\tty\Layout;

$tty    = new Terminal();
$prompt = new Prompt($tty);

//$tty->clearScreen();

// Create layout with scroll area of 5 rows.
$layout = Layout::withStatusAndScroll($tty, 5);
for($i = 0; $i < 3; $i++) {
    echo "1234 sdgsdg\n";
}

$status = $layout->getStatusLine();
$area   = $layout->getScrollArea();

$status->setText('boru\\tty demo: layout + scroll + status');

$area->setLines(array('Initializing...'));

for ($i = 1; $i <= 10; $i++) {
    $area->addLine('Log message #' . $i);
    usleep(200000);
}

$name   = $layout->ask($prompt, 'What is your name', 'Anonymous');
$secret = $layout->secret($prompt, 'Enter a secret');

$area->addLine('Hello, ' . $name . ' (secret length: ' . strlen($secret) . ')');

$status->setText('Done. Press Enter to exit.');
$layout->ask($prompt, 'Press Enter to exit', null);

// Clean exit: move below scroll area on a clear line
$layout->moveToCleanExitLine();
$tty->writeln();
