<?php

namespace boru\tty;

class StatusLine
{
    /** @var Terminal */
    protected $tty;

    /** @var int */
    protected $row;

    /** @var int */
    protected $lastWidth = 0;

    public function __construct(Terminal $tty, $row)
    {
        $this->tty = $tty;
        $this->row = (int) $row;
    }

    public static function bottom(Terminal $tty)
    {
        list($cols, $rows) = $tty->getSize();
        return new self($tty, $rows);
    }

    public function setText($text)
    {
        list($cols,) = $this->tty->getSize();

        $this->tty->saveCursor();
        $this->tty->moveCursorTo($this->row, 1);
        $this->tty->clearLine();

        $display = (string) $text;
        if (strlen($display) > $cols) {
            $display = substr($display, 0, $cols);
        }

        $this->tty->write($display);
        $this->tty->restoreCursor();

        $this->lastWidth = strlen($display);
    }

    public function clear()
    {
        $this->tty->saveCursor();
        $this->tty->moveCursorTo($this->row, 1);
        $this->tty->clearLine();
        $this->tty->restoreCursor();
        $this->lastWidth = 0;
    }
}
