<?php

namespace boru\tty\Util;

class Ansi
{
    public static function esc($code)
    {
        return "\x1b[" . $code;
    }

    public static function cursorPosition($row, $col)
    {
        return self::esc($row . ';' . $col . 'H');
    }

    public static function cursorMove($dRow, $dCol)
    {
        $seq = '';

        if ($dRow < 0) {
            $seq .= self::esc(abs($dRow) . 'A'); // up
        } elseif ($dRow > 0) {
            $seq .= self::esc($dRow . 'B');      // down
        }

        if ($dCol > 0) {
            $seq .= self::esc($dCol . 'C');      // right
        } elseif ($dCol < 0) {
            $seq .= self::esc(abs($dCol) . 'D'); // left
        }

        return $seq;
    }

    public static function clearScreen()
    {
        // Clear screen and move cursor to home
        return self::esc('2J') . self::cursorPosition(1, 1);
    }

    /**
     * $mode: 0 = clear from cursor right, 1 = clear from cursor left, 2 = entire line
     */
    public static function clearLine($mode = 2)
    {
        return self::esc($mode . 'K');
    }

    public static function hideCursor()
    {
        return self::esc('?25l');
    }

    public static function showCursor()
    {
        return self::esc('?25h');
    }

    public static function sgr(array $codes)
    {
        if (empty($codes)) {
            return '';
        }

        return self::esc(implode(';', $codes) . 'm');
    }

    public static function reset()
    {
        return self::esc('0m');
    }

    // Simple color helpers ---------------------------------------------------

    public static function fg($color)
    {
        $map = array(
            'black'   => 30,
            'red'     => 31,
            'green'   => 32,
            'yellow'  => 33,
            'blue'    => 34,
            'magenta' => 35,
            'cyan'    => 36,
            'white'   => 37,
            'default' => 39,
        );

        return isset($map[$color]) ? self::sgr(array($map[$color])) : '';
    }

    public static function bg($color)
    {
        $map = array(
            'black'   => 40,
            'red'     => 41,
            'green'   => 42,
            'yellow'  => 43,
            'blue'    => 44,
            'magenta' => 45,
            'cyan'    => 46,
            'white'   => 47,
            'default' => 49,
        );

        return isset($map[$color]) ? self::sgr(array($map[$color])) : '';
    }

    public static function bold()
    {
        return self::sgr(array(1));
    }

    public static function dim()
    {
        return self::sgr(array(2));
    }

    public static function underline()
    {
        return self::sgr(array(4));
    }
}
