<?php
namespace boru\vtutil;

use PhpOffice\PhpSpreadsheet\IOFactory;

chdir(dirname(__FILE__) . '/../../');
include_once 'includes/main/WebUI.php';
require_once 'config.inc.php';
require_once 'include/utils/utils.php';
require_once 'vtlib/Vtiger/Module.php';
require_once 'include/database/PearDatabase.php';
require_once 'libraries/PHPExcel/PHPExcel/IOFactory.php';

global $adb;
if (!$adb) {
    $adb = \PearDatabase::getInstance();
}

class VTUtil {
    public static function helloWorld() {
        return "Hello, VTUtil!";
    }

    public static function getRecordInstance($module, $recordId) {
        if (isRecordExists($recordId)) {
            return \Vtiger_Record_Model::getInstanceById($recordId, $module);
        }
        return null;
    }

    public static function log($filename, $content, $maxSize = 5242880, $maxFiles = 5) {
        $logDir = __DIR__ . '/logs';
        if (!is_dir($logDir)) {
            mkdir($logDir, 0777, true);
        }
        $logFile = $logDir . '/' . $filename . '.log';

        if (file_exists($logFile) && filesize($logFile) >= $maxSize) {
            self::rotateLogs($logFile, $maxFiles);
        }

        $date = date("Y-m-d H:i:s");
        $message = "[$date] " . $content . PHP_EOL;
        file_put_contents($logFile, $message, FILE_APPEND);
    }

    /**
     * Rotate logs: file.log -> file.log.1, file.log.1 -> file.log.2.gz ...
     */
    private static function rotateLogs($logFile, $maxFiles) {
        if (file_exists($logFile . '.' . $maxFiles . '.gz')) {
            unlink($logFile . '.' . $maxFiles . '.gz');
        }
        // Rotate others
        for ($i = $maxFiles - 1; $i >= 1; $i--) {
            $oldFile = $logFile . '.' . $i . '.gz';
            $newFile = $logFile . '.' . ($i + 1) . '.gz';
            if (file_exists($oldFile)) {
                rename($oldFile, $newFile);
            }
        }
        // Compress last rotated file
        if (file_exists($logFile . '.1')) {
            $data = file_get_contents($logFile . '.1');
            file_put_contents($logFile . '.1.gz', gzencode($data, 9));
            unlink($logFile . '.1');
        }
        // Move current log -> .1
        rename($logFile, $logFile . '.1');
    }

    public static function readSpreadsheet($filePath) {
        if (!file_exists($filePath)) {
            throw new \Exception("File not found: $filePath");
        }

        $extension = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));
        if ($extension === 'csv') {
            $data = [];
            if (($handle = fopen($filePath, "r")) !== false) {
                while (($row = fgetcsv($handle)) !== false) {
                    $data[] = $row;
                }
                fclose($handle);
            }
            return $data;
        } elseif (in_array($extension, ['xlsx', 'xls'])) {
            $spreadsheet = \PHPExcel_IOFactory::load($filePath);
            $sheet = $spreadsheet->getActiveSheet();
            return $sheet->toArray();
        } else {
            throw new \Exception("Unsupported file type: $extension");
        }
    }
    public static function updateRecordData($module, $recordId, $fields, $hasLineItems = false) {
        $focus = \CRMEntity::getInstance($module);
        $focus->id = $recordId;
        $focus->mode = 'edit';
        $focus->retrieve_entity_info($recordId, $module);

        if ($hasLineItems) {
            $focus->isLineItemUpdate = false;
        }

        foreach ($fields as $field => $value) {
            $focus->column_fields[$field] = $value;
        }
        try {
            if ($hasLineItems) {
                $focus->saveentity($module);
            } else {
                $focus->save($module);
            }
        } catch (\Exception $e) {
            $e->getMessage();
        }
    }
}
